#ifndef _fma_settings_h_
#define _fma_settings_h_

#include "lf_fma_comm.h"

/* Default values for settings */
#define FMA_DFLT_NIC_SCOUT_TIMEOUT 250
#define FMA_DFLT_NIC_SCOUT_RETRIES 3
#define FMA_DFLT_VERIFY_TIMEOUT 300
#define FMA_DFLT_VERIFY_RETRIES 50
#define FMA_DFLT_VERIFY_INTERVAL 40000
#define FMA_DFLT_NIC_QUERY_INTERVAL 60000
#define FMA_DFLT_NIC_BADCRC_THRESHOLD 2

/*
 * Settable parameters for the FMA.  We default these, and the FMS
 * can override them
 */
struct fma_settings {
  int nic_scout_timeout;
  int nic_scout_retries;
  int verify_interval;
  int verify_retries;
  int verify_timeout;
  int nic_query_interval;
  int nic_badcrc_threshold;
};

/*
 * Prototypes
 */
void fma_fms_set_settings(struct lf_fma_settings *);


#endif /* _fma_settings_h_ */
